---
title: Make XZ archives using ALL your cores
date: 2025-03-31T11:06:13+01:00
draft: false
tags:
  - ubuntu
  - debian
  - sysadmin
---
If you've ever used tar, you'll realise it's really slow when it comes to compressing. That's because the compression is pinned to one core by default - or, at least that's what I've found.

For the following commands, you'll need GNU tar. If you're on Linux, you'll have it already, but if you're on BSD, you'll need to install GNU tar and use it with `gtar` instead of `tar`.

In the GNU version of tar, there is a switch, `-I`, which allows you to specify the compression command. Using `xz -T0` as this command you can use all of the cores in your system to compress files.

For example, to compress the folder `driving2` into a file called `driving2.tar.xz` using all possible cores for compression, you would run this command:
```
tar -c -I 'xz -T0' -f ./driving2.tar.xz ./driving2
```

And as you can see, all the cores are being used:
![[Pasted image 20250331111347.png]]